﻿using System;
using System.Reflection;
using System.Windows;
using System.Windows.Input;
using System.Windows.Media.Imaging;
using PPScanControl;

namespace WPF_ScanControl_Sample
{
    /// <summary>
    /// A673F_CalibrateWizard.xaml 的互動邏輯
    /// </summary>
    public partial class A6_CalibrateWizard : Window
    {
        private readonly ScanControl _scanControl;

        public A6_CalibrateWizard(ScanControl scanControl)
        {
            InitializeComponent();
            _scanControl = scanControl;
            if (_scanControl.GetConnectedScanner() == ScannerType.A6_73F)
            {
                img.Source = new BitmapImage(new Uri(@"pack://application:,,,/wizard_73F.png"));
            }
        }

        private void BtnCalibrate_OnClick(object sender, RoutedEventArgs e)
        {
            btnCalibrate.IsEnabled = false;
            Cursor = Cursors.Wait;
            ReturnCode code = _scanControl.Calibrate();
            Cursor = Cursors.Arrow;
            MainWindow.ShowErrorMessage(this, code);
            if (code == ReturnCode.Success)
            {
                Close();
            }
            else
            {
                btnCalibrate.IsEnabled = true;
            }
        }
    }
}
